<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Addressbook extends CI_Controller
{
    public function index()
    { 
        	$settings = apiCall('getSettings');
			
			$settings=$settings['details']['settings'];
			
			$this->session->set_userdata('settings',$settings);
			
        $profiledata = apiCall('GetProfile');
        //p($profiledata);
        $getloc = json_decode(file_get_contents("http://ipinfo.io/"));
        $coordinates = explode(",", $getloc->loc);
        $countrylist = apiCall('getMobileCodeList');

        $data = [
            'id' => isset($_GET['id'])?$_GET['id']:'',
            'user_token' => $this->session->userdata('token'),
            'lat' => $coordinates[0],
            'lng' => $coordinates[1]
        ];
        $address = $this->session->userdata('address');
        $response = apiCall('getAddressBookByID',$data,'');
        $OrderList = apiCall('OrderList');
        $credit = apiCall('CrediCartList');
        $BookingList = apiCall('BookingList',['tab'=>'all']);
        renderView($this, 'addressbook/index',['address'=>$address,'bookingList'=>$BookingList['details'],'profileData' => $profiledata,'countrylist' => $countrylist['details']['data'],'OrderList' => $OrderList['details'],'addressdata' => $response['details'],'creditlist' => $credit['details']]);

    }

    public function getaddressbook()
    {

        $addressbook = apiCall('AddressBookList');
        //p($addressbook);
        if($addressbook['code']==1) {
            foreach ($addressbook['details']['data'] as $key => $row) {
                if($row['as_default']==1){
                    $addressbook['details']['data'][$key]['as_default'] = '<i class="fa fa-times"></i>';
                }else{
                    $addressbook['details']['data'][$key]['as_default'] = $row['as_default'];
                }

                    $addressbook['details']['data'][$key]['action'] = '<a class="edit_addressbook" href="addressbook?id=' . $row['id'] . '"><i style="font-size: 25px;" class="ion-ios-compose-outline"></i></a> <a href="addressbook/deleteaddressbook?id=' . $row['id'] . '" class="delete_addressbook"><i style="font-size: 25px;" class="ion-ios-trash"></i></a>';

        }
        }
        echo json_encode($addressbook['details']);

    }

    public function deleteaddressbook()
    {
        $data=[
            'id' => $_GET['id']
        ];
        $response = apiCall('DeleteAddressBook',$data,'');
            redirect('profile');
    }


    public function createaddressbook()
    {

        $getloc = json_decode(file_get_contents("http://ipinfo.io/"));
        $coordinates = explode(",", $getloc->loc);
        $this->form_validation->set_rules('street', 'Street', 'required');
        $this->form_validation->set_rules('city', 'City', 'required');
        $this->form_validation->set_rules('state', 'State', 'required');
        $this->form_validation->set_rules('zipcode', 'ZipCode', 'required');
        $this->form_validation->set_rules('location_name', 'Location Name', 'required');
        if (isset($_POST) && $_POST) {
            if ($this->form_validation->run() == TRUE) {
            $data = [
                'id' => isset($_POST['id'])?$_POST['id']:'',
                'street' => @$_POST['street'],
                'city' => @$_POST['city'],
                'state' => @$_POST['state'],
                'zipcode' => @$_POST['zipcode'],
                'location_name' => @$_POST['location_name'],
                'country_code' => @$_POST['country_code'],
                'as_default' => @$_POST['as_default'],
                'lat' => $coordinates[0],
                'lng' => $coordinates[1],
                'user_token' => $this->session->userdata('token'),
            ];
            $response = apiCall('saveAddressBook', '', $data);
            if ($response['code'] == 1) {
                if($_POST['id'])
                {
                    $this->session->set_flashdata('success', 'Address Changed Successfully');
                }else{
                $this->session->set_flashdata('success', 'Address Added Successfully');
                }
                redirect('profile');
            } else {
                $this->session->set_flashdata('error', $response['msg']);
                redirect('profile');
            }
        }else{
                $this->session->set_flashdata('error','All Fields are required');
                redirect('profile');
            }}


    }

    public function save_addressbook()
    {
        $getloc = json_decode(file_get_contents("http://ipinfo.io/"));
        $coordinates = explode(",", $getloc->loc);

        $data = [
            'street' => $_POST['street'],
            'city' => $_POST['city'],
            'state' => $_POST['state'],
            'zipcode' => $_POST['zipcode'],
            'location_name' => $_POST['location_name'],
            'country_code' => $_POST['country_code'],
            'lat' => $coordinates[0],
            'lng' => $coordinates[1],
            'user_token' => $this->session->userdata('token'),
        ];
        $response = apiCall('saveAddressBook', '', $data);
        //p($response);
        echo json_encode($response);
    }

}